% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{resp}
\alias{resp}
\title{Respiratory dataset}
\format{
A data frame with 10 variables.

\code{ID}:  Participant ID

\code{Center}:  Treatment center

\code{Sex}:  Participant sex at birth

\code{Age}:  Participant age at baseline

\code{Treatment}:  T=treatment arm, C=control arm

\code{Baseline}:  Ordinal global rating at Baseline: 0 for terrible, 1 for poor, 2 for fair,
3 for good, and 4 for excellent

\code{Visit1}:  Ordinal global rating at Visit 1: 0 for terrible, 1 for poor, 2 for fair,
3 for good, and 4 for excellent

\code{Visit2}:  Ordinal global rating at Visit 2: 0 for terrible, 1 for poor, 2 for fair,
3 for good, and 4 for excellent

\code{Visit3}:  Ordinal global rating at Visit 3: 0 for terrible, 1 for poor, 2 for fair,
3 for good, and 4 for excellent

\code{Visit4}:  Ordinal global rating at Visit 4: 0 for terrible, 1 for poor, 2 for fair,
3 for good, and 4 for excellent
}
\usage{
resp
}
\description{
The respiratory dataset originates from a randomized clinical trial that
evaluated a test treatment against a control in managing a chronic respiratory
condition \insertCite{koch_1989,stokes_2012}{winr}. The study involved 111
patients—54 receiving the active treatment and 57 on a placebo—distributed
across two centers. Assessments were conducted at baseline and during four
subsequent follow-up visits. At each visit, patients' respiratory status was
evaluated using an ordinal scale where 0 signifies `terrible', 1 is `poor',
2 stands for `fair', 3 represents `good', and 4 denotes `excellent'.
The participating centers serve as stratification factors, and the baseline
variables include age, sex, and initial respiratory status.
}
\references{
{
   \insertAllCited{}
}
}
\keyword{datasets}
