% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windsor_fetch.R
\name{windsor_fetch}
\alias{windsor_fetch}
\title{Windsor fetch
A function to fetch data from the Windsor.ai API}
\usage{
windsor_fetch(
  api_key,
  connector = "all",
  date_preset = "last_7d",
  fields = c("source", "campaign", "clicks", "medium", "sessions", "spend")
)
}
\arguments{
\item{api_key}{Your api key to access Windsor.ai API}

\item{connector}{A connector for the data source.
The connector "all" connector blends data from all sources
See https://www.windsor.ai/api-fields/ for details.}

\item{date_preset}{the period for which data is fetched from the API.
See https://www.windsor.ai/api-fields/ for details}

\item{fields}{The fields fetched from the API for a given connector
See https://www.windsor.ai/api-fields/ for details.}
}
\value{
A data frame containing the desired data.
}
\description{
Windsor fetch
A function to fetch data from the Windsor.ai API
}
\examples{
\dontrun{
windsor_fetch <- (api_key = "your api key",
connector = "all",
date_preset = "last_7d",
fields = c("source", "campaign", "clicks",
           "medium", "sessions", "spend"))
}
}
