% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_define.R
\name{wiki_define}
\alias{wiki_define}
\title{Define a term from Wikipedia}
\usage{
wiki_define(term = NULL, sentences = 5L)
}
\arguments{
\item{term}{A non-empty character string or vector giving the name(s) of the term to be searched}

\item{sentences}{An integer (or whole number) giving the number of sentences to return}
}
\value{
An extract from the Wikipedia article
}
\description{
`wiki_define()` displays plaintext extract(s) of the given term(s) from
' the Wikipedia article(s).
}
\examples{
wiki_define('R (programming language)')

animals <- data.frame(name = c("dog", "cat"))
animals$definition <- wiki_define(animals$name, sentences = 1)
print(animals)
}
