% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{CVAbiplot}
\alias{CVAbiplot}
\title{Plot the CVA biplot}
\usage{
CVAbiplot(
  x,
  which.var = 1:x$p,
  var.label = FALSE,
  group.col = NULL,
  zoom.out = 50
)
}
\arguments{
\item{x}{Object from CVA}

\item{which.var}{which variable to display on the biplot}

\item{var.label}{whether to display label for variable name}

\item{group.col}{vector of colours for the groups in the data}

\item{zoom.out}{percentage to zoom out of the plot}
}
\value{
A CVA biplot based on the GSVD
}
\description{
Plot the CVA biplot
}
\examples{
data(sim_data)
CVAgsvd(X=sim_data[,2:301],group = sim_data[,1])|>
CVAbiplot(group.col=c("tan1","darkcyan","darkslateblue"),which.var = 1:10,zoom.out=80)
}
