% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_bands_transition}
\alias{predict_bands_transition}
\title{Extract confidence and prediction bands for the transition phase}
\usage{
predict_bands_transition(
  .data,
  time_column,
  vo2_column,
  cleaning_level,
  cleaning_model
)
}
\arguments{
\item{.data}{The nornalized data retrieved from \code{normalize_transitions()}. The data should be filtered to only the 'transition' phase before passing to the function.}

\item{time_column}{The name (quoted) of the column containing the time. Depending on the language of your system, this column might not be "t". Therefore, you may specify it here.  Default to "t".}

\item{vo2_column}{The name (quoted) of the column containing the absolute oxygen uptake (VO2) data. Default to 'VO2'.}

\item{cleaning_level}{A numeric scalar between 0 and 1 giving the confidence level for the intervals to be calculated.}

\item{cleaning_model}{The \code{nls} model to retrieve the bands from.}
}
\value{
a \link[tibble:tibble-package]{tibble} containing the following columns:
\item{x}{The provided time data.}
\item{y}{The provided VO2 data.}
\item{.fitted}{The predicted response for that observation.}
\item{.resid}{The residual for a particular point.}
\item{lwr_conf}{Lower limit of the confidence band.}
\item{upr_conf}{Upper limit of the confidence band.}
\item{lwr_pred}{Lower limit of the prediction band.}
\item{upr_pred}{Upper limit of the prediction band.}
}
\description{
Extract confidence and prediction bands for the transition phase
}
