% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/level_time.R
\name{select_time_level}
\alias{select_time_level}
\alias{select_time_level.when}
\title{Select time level}
\usage{
select_time_level(td, include_all, exclude_all, time, minute, second, day_part)

\method{select_time_level}{when}(
  td,
  include_all = FALSE,
  exclude_all = FALSE,
  time = NULL,
  minute = NULL,
  second = NULL,
  day_part = NULL
)
}
\arguments{
\item{td}{A \code{when} object.}

\item{include_all}{A boolean, include all fields of the level.}

\item{exclude_all}{A boolean, exclude all fields of the level.}

\item{time}{A boolean, include a field for the time.}

\item{minute}{A boolean, include the minute level of detail.}

\item{second}{A boolean, include the second level of detail.}

\item{day_part}{A boolean, include the parts of the day.}
}
\value{
A \code{when} object.
}
\description{
When the dimension is defined as a time type, using this function we can select
the level and its attributes to include in it: time, minute, second and day_part.
}
\details{
The 'hour' attribute will always be included. If the 'minute' attribute is not
included the 'second' attribute will not be included either.
}
\examples{

td <- when() |>
  select_time_level(day_part = FALSE)

}
\seealso{
Other dimension definition: 
\code{\link{define_characteristics}()},
\code{\link{define_instances}()},
\code{\link{get_attribute_definition_function}()},
\code{\link{get_day_part}()},
\code{\link{get_week_date_range}()},
\code{\link{select_date_levels}()},
\code{\link{select_day_level}()},
\code{\link{select_month_level}()},
\code{\link{select_quarter_level}()},
\code{\link{select_semester_level}()},
\code{\link{select_week_level}()},
\code{\link{select_year_level}()},
\code{\link{set_attribute_definition_function}()},
\code{\link{set_day_part}()},
\code{\link{when}()}
}
\concept{dimension definition}
