% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_team.R
\name{wnba_teamestimatedmetrics}
\alias{wnba_teamestimatedmetrics}
\title{\strong{Get WNBA Stats API Team Estimated Metrics}}
\usage{
wnba_teamestimatedmetrics(
  league_id = "10",
  season = most_recent_wnba_season(),
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: TeamEstimatedMetrics

\strong{TeamEstimatedMetrics}\tabular{ll}{
   col_name \tab types \cr
   TEAM_NAME \tab character \cr
   TEAM_ID \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   E_OFF_RATING \tab character \cr
   E_DEF_RATING \tab character \cr
   E_NET_RATING \tab character \cr
   E_PACE \tab character \cr
   E_AST_RATIO \tab character \cr
   E_OREB_PCT \tab character \cr
   E_DREB_PCT \tab character \cr
   E_REB_PCT \tab character \cr
   E_TM_TOV_PCT \tab character \cr
   GP_RANK \tab character \cr
   W_RANK \tab character \cr
   L_RANK \tab character \cr
   W_PCT_RANK \tab character \cr
   MIN_RANK \tab character \cr
   E_OFF_RATING_RANK \tab character \cr
   E_DEF_RATING_RANK \tab character \cr
   E_NET_RATING_RANK \tab character \cr
   E_AST_RATIO_RANK \tab character \cr
   E_OREB_PCT_RANK \tab character \cr
   E_DREB_PCT_RANK \tab character \cr
   E_REB_PCT_RANK \tab character \cr
   E_TM_TOV_PCT_RANK \tab character \cr
   E_PACE_RANK \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Team Estimated Metrics}

\strong{Get WNBA Stats API Team Estimated Metrics}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_teamestimatedmetrics()
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Team Functions: 
\code{\link{wnba_leaguedashteamstats}()},
\code{\link{wnba_teamdashboardbyclutch}()},
\code{\link{wnba_teamdashboardbygamesplits}()},
\code{\link{wnba_teamdashboardbygeneralsplits}()},
\code{\link{wnba_teamdashboardbylastngames}()},
\code{\link{wnba_teamdashboardbyopponent}()},
\code{\link{wnba_teamdashboardbyshootingsplits}()},
\code{\link{wnba_teamdashboardbyteamperformance}()},
\code{\link{wnba_teamdashboardbyyearoveryear}()},
\code{\link{wnba_teamdashlineups}()},
\code{\link{wnba_teamdetails}()},
\code{\link{wnba_teamgamelogs}()},
\code{\link{wnba_teamgamelog}()},
\code{\link{wnba_teamgamestreakfinder}()},
\code{\link{wnba_teamhistoricalleaders}()},
\code{\link{wnba_teamplayerdashboard}()},
\code{\link{wnba_teamplayeronoffdetails}()},
\code{\link{wnba_teamplayeronoffsummary}()},
\code{\link{wnba_teams}()},
\code{\link{wnba_teamvsplayer}()},
\code{\link{wnba_teamyearbyyearstats}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Team Functions}
