% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/located_in_shapefile.R
\name{located_in_shapefile}
\alias{located_in_shapefile}
\title{Locations In the Shapefile}
\usage{
located_in_shapefile(
  .,
  lat_column = "lat",
  lng_column = "lng",
  shapefile = NA,
  shapefile_name = NA
)
}
\arguments{
\item{.}{Data Frame that has been locationized. see \code{weed::split_locations}}

\item{lat_column}{Name of column containing Latitude data}

\item{lng_column}{Name of column containing Longitude data}

\item{shapefile}{The shapefile itself (either shapefile or shapefile_name must be provided)}

\item{shapefile_name}{FileName/Path to shapefile (either shapefile or shapefile_name must be provided)}
}
\value{
Data Frame with the shapefile data as well as the previous data
}
\description{
Creates a new column (in_shape) that tells whether the lat/long is in a certain shapefile.
}
\examples{
\dontrun{
d <- tibble::tribble(
~value,  ~location_word,                    ~Country,     ~lat,       ~lng,
"city of new york",      "new york",                       "USA", 40.71427,  -74.00597,
"kerala, chennai municipality, and san francisco",  "kerala", "India", 10.41667,       76.5,
"kerala, chennai municipality, and san francisco",  "chennai",  "India", 13.08784,   80.2847)
located_in_shapefile(d,
lat_column = "lat",
lng_column = "lng",
shapefile_name = "~/dummy_name")
}
}
