% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numSummary.R
\name{numSummary}
\alias{numSummary}
\alias{numSummary1}
\alias{numSummary2}
\title{Numerical Summary}
\usage{
numSummary(x, ..., digits = 2, lang = "en")

numSummary1(x, ..., digits = 2, lang = "en")

numSummary2(x, ..., digits = 2, lang = "en")
}
\arguments{
\item{x}{A numeric vector or a data.frame or a grouped_df}

\item{...}{further arguments to be passed}

\item{digits}{integer indicating the number of decimal places}

\item{lang}{Language. choices are one of c("en","kor")}
}
\description{
Numerical Summary
}
\section{Functions}{
\itemize{
\item \code{numSummary1}: Numerical Summary of a data.frame or a vector

\item \code{numSummary2}: Numerical Summary of a grouped_df
}}

\examples{
require(moonBook)
require(magrittr)
require(dplyr)
require(rrtable)
require(webr)
require(tibble)
numSummary(acs)
numSummary(acs$age)
numSummary(acs,age,EF)
acs \%>\% group_by(sex) \%>\% numSummary(age,BMI)
acs \%>\% group_by(sex) \%>\% select(age) \%>\% numSummary
acs \%>\% group_by(sex) \%>\% select(age,EF) \%>\% numSummary
acs \%>\% group_by(sex,Dx) \%>\% select(age,EF) \%>\% numSummary
acs \%>\% group_by(sex,Dx) \%>\% select(age) \%>\% numSummary
#acs \%>\% group_by(sex,Dx) \%>\% numSummary(age,EF,lang="kor")
}
