% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PieDonut.R
\name{PieDonut}
\alias{PieDonut}
\title{Draw a PieDonut plot}
\usage{
PieDonut(
  data,
  mapping,
  start = getOption("PieDonut.start", 0),
  addPieLabel = TRUE,
  addDonutLabel = TRUE,
  showRatioDonut = TRUE,
  showRatioPie = TRUE,
  ratioByGroup = TRUE,
  showRatioThreshold = getOption("PieDonut.showRatioThreshold", 0.02),
  labelposition = getOption("PieDonut.labelposition", 2),
  labelpositionThreshold = 0.1,
  r0 = getOption("PieDonut.r0", 0.3),
  r1 = getOption("PieDonut.r1", 1),
  r2 = getOption("PieDonut.r2", 1.2),
  explode = NULL,
  selected = NULL,
  explodePos = 0.1,
  color = "white",
  pieAlpha = 0.8,
  donutAlpha = 1,
  maxx = NULL,
  showPieName = TRUE,
  showDonutName = FALSE,
  title = NULL,
  pieLabelSize = 4,
  donutLabelSize = 3,
  titlesize = 5,
  explodePie = TRUE,
  explodeDonut = FALSE,
  use.label = TRUE,
  use.labels = TRUE,
  family = getOption("PieDonut.family", "")
)
}
\arguments{
\item{data}{A data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{start}{offset of starting point from 12 o'clock in radians}

\item{addPieLabel}{A logical value. If TRUE, labels are added to the Pies}

\item{addDonutLabel}{A logical value. If TRUE, labels are added to the Donuts}

\item{showRatioDonut}{A logical value. If TRUE, ratios are added to the DonutLabels}

\item{showRatioPie}{A logical value. If TRUE, ratios are added to the PieLabels}

\item{ratioByGroup}{A logical value. If TRUE, ratios ara calculated per group}

\item{showRatioThreshold}{An integer. Threshold to show label as a ratio of total. default value is 0.02.}

\item{labelposition}{A number indicating the label position}

\item{labelpositionThreshold}{label position threshold. Default value is 0.1.}

\item{r0}{Integer. start point of pie}

\item{r1}{Integer. end point of pie}

\item{r2}{Integer. end point of donut}

\item{explode}{pies to explode}

\item{selected}{donuts to explode}

\item{explodePos}{explode position}

\item{color}{color}

\item{pieAlpha}{transparency of pie}

\item{donutAlpha}{transparency of pie}

\item{maxx}{maximum position of plot}

\item{showPieName}{logical. Whether or not show Pie Name}

\item{showDonutName}{logical. Whether or not show Pie Name}

\item{title}{title of plot}

\item{pieLabelSize}{integer. Pie label size}

\item{donutLabelSize}{integer. Donut label size}

\item{titlesize}{integer. Title size}

\item{explodePie}{Logical. Whether or not explode pies}

\item{explodeDonut}{Logical. Whether or not explode donuts}

\item{use.label}{Logical. Whether or not use column label in case of labelled data}

\item{use.labels}{Logical. Whether or not use value labels in case of labelled data}

\item{family}{font family}
}
\description{
Draw a PieDonut plot
}
\examples{
require(moonBook)
require(ggplot2)
browser=c("MSIE","Firefox","Chrome","Safari","Opera")
share=c(50,21.9,10.8,6.5,1.8)
df=data.frame(browser,share)
PieDonut(df,aes(browser,count=share),r0=0.7,start=3*pi/2,labelpositionThreshold=0.1)
\donttest{
PieDonut(df,aes(browser,count=share),r0=0.7,explode=5,start=3*pi/2)
PieDonut(mtcars,aes(gear,carb),start=3*pi/2,explode=3,explodeDonut=TRUE,maxx=1.7)
PieDonut(mtcars,aes(carb,gear),r0=0)
PieDonut(acs,aes(smoking,Dx),title="Distribution of smoking status by diagnosis")
PieDonut(acs,aes(Dx,smoking),ratioByGroup=FALSE,r0=0)
PieDonut(acs,aes(Dx,smoking),selected=c(1,3,5,7),explodeDonut=TRUE)
PieDonut(acs,aes(Dx,smoking),explode=1,selected=c(2,4,6,8),labelposition=0,explodeDonut=TRUE)
PieDonut(acs,aes(Dx,smoking),explode=1)
PieDonut(acs,aes(Dx,smoking),explode=1,explodeDonut=TRUE,labelposition=0)
PieDonut(acs,aes(Dx,smoking),explode=1,explodePie=FALSE,explodeDonut=TRUE,labelposition=0)
PieDonut(acs,aes(Dx,smoking),selected=c(2,5,8), explodeDonut=TRUE,start=pi/2,labelposition=0)
PieDonut(acs,aes(Dx,smoking),r0=0.2,r1=0.9,r2=1.3,explode=1,start=pi/2,explodeDonut=TRUE)
PieDonut(acs,aes(Dx,smoking),r0=0.2,r1=0.9,r2=1.3,explode=1,start=pi/2,labelposition=0)
PieDonut(acs,aes(Dx,smoking),explode=1,start=pi,explodeDonut=TRUE,labelposition=0)
require(dplyr)
df=mtcars \%>\% group_by(gear,carb) \%>\% summarize(n=n())
PieDonut(df,aes(pies=gear,donuts=carb,count=n),ratioByGroup=FALSE)
}
}
