% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{Session}
\alias{Session}
\title{WebDriver session}
\description{
Drive a headless phantom.js browser via the WebDriver protocol.
It needs phantom.js running in WebDriver mode.
}
\section{Usage}{

\preformatted{s <- Session$new(host = "127.0.0.1", port = 8910)

s$delete()
s$status()

s$go(url)
s$getUrl()
s$goBack()
s$goForward()
s$refresh()
s$getTitle()
s$getSource()
s$takeScreenshot(file = NULL)

s$findElement(css = NULL, linkText = NULL,
    partialLinkText = NULL, xpath = NULL)
s$findElements(css = NULL, linkText = NULL,
    partialLinkText = NULL, xpath = NULL)

s$executeScript(script, ...)
s$executeScriptAsync(script, ...)

s$setTimeout(script = NULL, pageLoad = NULL, implicit = NULL)

s$moveMouseTo(xoffset = 0, yoffset = 0)
s$click(button = c("left", "middle", "right"))
s$doubleClick(button = c("left", "middle", "right"))
s$mouseButtonDown(button = c("left", "middle", "right"))
s$mouseButtonUp(button = c("left", "middle", "right"))

s$readLog(type = c("browser", "har"))
s$getLogTypes()

s$waitFor(expr, checkInterval = 100, timeout = 3000)
}
}

\section{Arguments}{

\describe{
  \item{s}{A \code{Session} object.}
  \item{host}{Host name of phantom.js.}
  \item{port}{Port of phantom.js.}
  \item{url}{URL to nagivate to.}
  \item{file}{File name to save the screenshot to. If \code{NULL}, then
    it will be shown on the R graphics device.}
  \item{css}{Css selector to find an HTML element.}
  \item{linkText}{Find HTML elements based on their \code{innerText}.}
  \item{partialLinkText}{Find HTML elements based on their
    \code{innerText}. It uses partial matching.}
  \item{xpath}{Find HTML elements using XPath expressions.}
  \item{script}{For \code{executeScript} and
    \code{executeScriptAsync}. JavaScript code to execute. It will be
    placed in the body of a function.}
  \item{...}{Arguments to the script, they will be put in a list
    called arguments. \code{\link{Element}} objects are automatically
    transformed to DOM element in JavaScript.}
  \item{script}{For \code{setTimeout}. Script execution timeout,
    in milliseconds. More below.}
  \item{pageLoad}{Page load timeout, in milliseconds. More below.}
  \item{implicit}{Implicit wait before calls that find elements, in
    milliseconds. More below.}
  \item{xoffset}{Horizontal offset for mouse movement, relative to the
    current position.}
  \item{yoffset}{Vertical offset for mouse movement, relative to the
    current position.}
  \item{button}{Mouse button. Either one of \code{"left"},
    \code{"middle"}, \code{"right"}, or an integer between 1 and 3.}
  \item{type}{Log type, a character scalar.}
  \item{expr}{A string scalar containing JavaScript code that
    evaluates to the condition to wait for.}
  \item{checkInterval}{How often to check for the condition, in
    milliseconds.}
  \item{timeout}{Timeout for the condition, in milliseconds.}
}
}

\section{Details}{


\code{Session$new()} creates a new WebDriver session.

\code{s$delete()} deletes a WebDriver session.

\code{s$status()} returns a status message from the server. It is a
named list, and contains version numbers and capabilities.

\code{s$go()} navigates to the supplied URL.

\code{s$getUrl()} returns the current URL.

\code{s$goBack()} is like the web browser's back button. It goes back
to the previous page.

\code{s$goForward()} is like the web browser's forward button.

\code{s$refresh()} is like the web browser's refresh button.

\code{s$getTitle()} returns the title of the current page.

\code{s$getSource()} returns the complete HTML source of a page,
in a character scalar.

\code{s$takeScreenshot()} takes a screenshot of the current page.
You can save it to a PNG file with the \code{file} argument, or
show it on the graphics device (if \code{file} is \code{NULL}).

\code{s$findElement()} finds a HTML element using a CSS selector,
XPath expression, or the \code{innerHTML} of the element. If multiple
elements match, then the first one is returned. The return value
is an \code{\link{Element}} object.

\code{s$findElements()} finds HTML elements using a CSS selector,
XPath expression, or the \code{innerHTML} of the element. All matching
elements are returned in a list of \code{\link{Element}} objects.

\code{s$executeScript()} executes JavaScript code. It places the code
in the body of a function, and then calls the function with the
additional arguments. These can be accessed from the function via the
\code{arguments} array. Returned DOM elements are automatically
converted to \code{\link{Element}} objects, even if they are inside
a list (or list of list, etc.).

\code{s$executeScriptAsync()} is similar, for asynchronous execution.
It place the script in a body of a function, and then calls the function
with the additional arguments and a callback function as the last
argument. The script must call this callback function when it
finishes its work. The first argument passed to the callback function
is returned. Returned DOM elements are automatically converted to
\code{\link{Element}} objects, even if they are inside a list (or list
of list, etc.).

\code{s$setTimeout()} sets various timeouts. The \sQuote{script}
timeout specifies a time to wait for scripts to run. The
sQuote{page load} timeout specifies a time to wait for the page loading
to complete. The \sQuote{implicit} specifies a time to wait for the
implicit element location strategy when locating elements. Their defaults
are different in the standard and in Phantom.js. In Phantom.js the
\sQuote{script} and \sQuote{page load} timeouts are set to infinity,
and the \sQuote{implicit} waiting time is 200ms.

\code{s$moveMouseTo()} moves the mouse cursor by the specified
offsets.

\code{s$click()} clicks the mouse at its current position, using
the specified button.

\code{s$doubleClick()} emulates a double click with the specified
mouse button.

\code{s$button_down()} emulates pressing the specified mouse button
down (and keeping it down).

\code{s$button_up()} emulates releasing the specified mouse button.

\code{s$getLogTypes()} returns the log types supported by the
server, in a character vector.

\code{s$readLog()} returns the log messages since the last
\code{readLog} call, in a data frame with columns \code{timestamp},
\code{level} and \code{message}.

\code{s$waitFor()} waits until a JavaScript expression evaluates
to \code{true}, or a timeout happens. It returns \code{TRUE} is the
expression evaluated to \code{true}, possible after some waiting. If
the expression has a syntax error or a runtime error happens, it
returns \code{NA}.
}

\seealso{
The WebDriver standard at
\url{https://w3c.github.io/webdriver/webdriver-spec.html}.
}
