% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is.inchikey_cs}
\alias{is.inchikey_cs}
\title{Check if input is a valid inchikey using ChemSpider API}
\usage{
is.inchikey_cs(x, apikey = NULL, verbose = getOption("verbose"))
}
\arguments{
\item{x}{character; input string}

\item{apikey}{character; your API key. If NULL (default),
\code{cs_check_key()} will look for it in .Renviron or .Rprofile.}

\item{verbose}{logical; print messages during processing to console?}
}
\value{
a logical
}
\description{
Check if input is a valid inchikey using ChemSpider API
}
\examples{
\dontrun{
# might fail if API is not available
is.inchikey_cs('BQJCRHHNABKAKU-KBQPJGBKSA-N')
is.inchikey_cs('BQJCRHHNABKAKU-KBQPJGBKSA')
is.inchikey_cs('BQJCRHHNABKAKU-KBQPJGBKSA-5')
is.inchikey_cs('BQJCRHHNABKAKU-KBQPJGBKSA-n')
is.inchikey_cs('BQJCRHHNABKAKU/KBQPJGBKSA/N')
is.inchikey_cs('BQJCRHHNABKAKU-KBQPJGBKXA-N')
is.inchikey_cs('BQJCRHHNABKAKU-KBQPJGBKSB-N')
}
}
\seealso{
\code{\link{is.inchikey}} for a pure-R implementation.
}
