% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ids_list_entities.R
\name{ids_list_entities}
\alias{ids_list_entities}
\title{List Available Entities from the World Bank International Debt Statistics
API}
\usage{
ids_list_entities()
}
\value{
A tibble containing the available entities and their attributes:
\describe{
\item{entity_id}{ISO 3166-1 alpha-3 code of the entity (e.g.,
"ZMB").}
\item{entity_name}{The standardized name of the entity (e.g.,
"Zambia").}
\item{entity_iso2code}{ISO 3166-1 alpha-2 code of the entity (e.g.,
"ZM").}
\item{entity_type}{The type of entity (e.g., "Country", "Region").}
\item{capital_city}{The capital city of the entity (e.g., "Lusaka").}
\item{region_id}{The unique identifier for the region (e.g., "SSF").}
\item{region_iso2code}{ISO 3166-1 alpha-2 code of the region (e.g., "ZG").}
\item{region_name}{The name of the region (e.g., "Sub-Saharan Africa").}
\item{admin_region_id}{The unique identifier for the administrative region
(e.g., "SSA").}
\item{admin_region_iso2code}{The ISO 3166-1 alpha-2 code for the
administrative region (e.g., "ZF").}
\item{admin_region_name}{The name of the administrative region (e.g.,
"Sub-Saharan Africa (excluding high income)").}
\item{lending_type_id}{The unique identifier for the lending type (e.g.,
"IDX").}
\item{lending_type_iso2code}{ISO code for the lending type (e.g., "XI").}
\item{lending_type_name}{The name of the lending type (e.g., "IDA").}
}
}
\description{
This function returns a tibble with available entities from the World Bank
International Debt Statistics (IDS) API. Each row provides details on
entities, including their unique identifiers, names, and types.
}
\examples{
ids_list_entities()

}
