
# This file is automatically generated, you probably don't want to edit this

rttestISOptions <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "rttestISOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            deps = NULL,
            group = NULL,
            yuen = TRUE,
            tr = 0.2,
            mest = FALSE,
            method = "mom",
            yuenbt = FALSE,
            nboot = 599,
            md = FALSE,
            ci = FALSE,
            es = FALSE,
            esci = FALSE, ...) {

            super$initialize(
                package="walrus",
                name="rttestIS",
                requiresData=TRUE,
                ...)

            private$..deps <- jmvcore::OptionVariables$new(
                "deps",
                deps,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"))
            private$..group <- jmvcore::OptionVariable$new(
                "group",
                group,
                suggested=list(
                    "nominal"),
                permitted=list(
                    "factor"))
            private$..yuen <- jmvcore::OptionBool$new(
                "yuen",
                yuen,
                default=TRUE)
            private$..tr <- jmvcore::OptionNumber$new(
                "tr",
                tr,
                default=0.2,
                min=0,
                max=0.5)
            private$..mest <- jmvcore::OptionBool$new(
                "mest",
                mest,
                default=FALSE)
            private$..method <- jmvcore::OptionList$new(
                "method",
                method,
                options=list(
                    "onestep",
                    "mom",
                    "median",
                    "mean"),
                default="mom")
            private$..yuenbt <- jmvcore::OptionBool$new(
                "yuenbt",
                yuenbt,
                default=FALSE)
            private$..nboot <- jmvcore::OptionInteger$new(
                "nboot",
                nboot,
                min=0,
                default=599)
            private$..md <- jmvcore::OptionBool$new(
                "md",
                md,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..es <- jmvcore::OptionBool$new(
                "es",
                es,
                default=FALSE)
            private$..esci <- jmvcore::OptionBool$new(
                "esci",
                esci,
                default=FALSE)

            self$.addOption(private$..deps)
            self$.addOption(private$..group)
            self$.addOption(private$..yuen)
            self$.addOption(private$..tr)
            self$.addOption(private$..mest)
            self$.addOption(private$..method)
            self$.addOption(private$..yuenbt)
            self$.addOption(private$..nboot)
            self$.addOption(private$..md)
            self$.addOption(private$..ci)
            self$.addOption(private$..es)
            self$.addOption(private$..esci)
        }),
    active = list(
        deps = function() private$..deps$value,
        group = function() private$..group$value,
        yuen = function() private$..yuen$value,
        tr = function() private$..tr$value,
        mest = function() private$..mest$value,
        method = function() private$..method$value,
        yuenbt = function() private$..yuenbt$value,
        nboot = function() private$..nboot$value,
        md = function() private$..md$value,
        ci = function() private$..ci$value,
        es = function() private$..es$value,
        esci = function() private$..esci$value),
    private = list(
        ..deps = NA,
        ..group = NA,
        ..yuen = NA,
        ..tr = NA,
        ..mest = NA,
        ..method = NA,
        ..yuenbt = NA,
        ..nboot = NA,
        ..md = NA,
        ..ci = NA,
        ..es = NA,
        ..esci = NA)
)

rttestISResults <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "rttestISResults",
    inherit = jmvcore::Group,
    active = list(
        ttest = function() private$.items[["ttest"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Robust Independent Samples T-Test")
            self$add(jmvcore::Table$new(
                options=options,
                name="ttest",
                title="Robust Independent Samples T-Test",
                rows="(deps)",
                clearWith=list(
                    "group",
                    "method",
                    "tr",
                    "nboot"),
                columns=list(
                    list(
                        `name`="var", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="test[yuen]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Yuen's test", 
                        `visible`="(yuen)"),
                    list(
                        `name`="t[yuen]", 
                        `title`="t", 
                        `type`="number", 
                        `visible`="(yuen)"),
                    list(
                        `name`="df[yuen]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(yuen)"),
                    list(
                        `name`="p[yuen]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(yuen)"),
                    list(
                        `name`="md[yuen]", 
                        `title`="Mean diff", 
                        `type`="number", 
                        `visible`="(yuen && md)"),
                    list(
                        `name`="cil[yuen]", 
                        `superTitle`="95% Confidence Interval", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(yuen && ci)"),
                    list(
                        `name`="ciu[yuen]", 
                        `superTitle`="95% Confidence Interval", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(yuen && ci)"),
                    list(
                        `name`="es[yuen]", 
                        `title`="\u03BE", 
                        `type`="number", 
                        `visible`="(yuen && es)"),
                    list(
                        `name`="escil[yuen]", 
                        `superTitle`="95% \u03BE Confidence Interval", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(yuen && esci)"),
                    list(
                        `name`="esciu[yuen]", 
                        `superTitle`="95% \u03BE Confidence Interval", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(yuen && esci)"),
                    list(
                        `name`="test[yuenbt]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Yuen's bootstrapped", 
                        `visible`="(yuen && yuenbt)"),
                    list(
                        `name`="t[yuenbt]", 
                        `title`="t", 
                        `type`="number", 
                        `visible`="(yuen && yuenbt)"),
                    list(
                        `name`="df[yuenbt]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(yuen && yuenbt)"),
                    list(
                        `name`="p[yuenbt]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(yuen && yuenbt)"),
                    list(
                        `name`="test[mest]", 
                        `title`="", 
                        `type`="text", 
                        `content`="M-estimator", 
                        `visible`="(mest)"),
                    list(
                        `name`="t[mest]", 
                        `title`="t", 
                        `type`="number", 
                        `visible`="(mest)"),
                    list(
                        `name`="df[mest]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(mest)"),
                    list(
                        `name`="p[mest]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(mest)"))))}))

rttestISBase <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "rttestISBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = "walrus",
                name = "rttestIS",
                version = c(1,0,0),
                options = options,
                results = rttestISResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE,
                requiresMissings = FALSE)
        }))

#' Robust Independent Samples T-Test
#'
#' Robust Independent Samples T-Test
#'
#' @examples
#' data('eurosoccer', package='WRS2')
#'
#' SpainGermany <- subset(eurosoccer, eurosoccer$League == 'Spain' | eurosoccer$League == 'Germany')
#' SpainGermany <- droplevels(SpainGermany)
#'
#' rttestIS(SpainGermany,
#'          dep = 'GoalsScored',
#'          group = 'League',
#'          yuen = TRUE,
#'          mest = TRUE)
#'
#' #
#' #  ROBUST INDEPENDENT SAMPLES T-TEST
#' #
#' #  Robust Independent Samples T-Test
#' #  ---------------------------------------------------------
#' #                                  t         df      p
#' #  ---------------------------------------------------------
#' #    GoalsScored    Yuen's test     0.297    17.3    0.770
#' #                   M-estimator    -0.933            0.993
#' #  ---------------------------------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param deps a vector of strings naming the dependent variables in
#'   \code{data}
#' @param group a string naming the grouping variable in \code{data}; must
#'   have 2 levels
#' @param yuen \code{TRUE} (default) or \code{FALSE}, use the Yuen's trim
#'   method
#' @param tr a number between 0 and 0.5, (default: 0.2), the proportion of
#'   measurements to trim from each end, when using the trim and bootstrap
#'   methods
#' @param mest \code{TRUE} or \code{FALSE} (default), use an M-estimator
#' @param method \code{'onestep'}, \code{'mom'} (default) or \code{'median'},
#'   the M-estimator to use; One-step, Modified one-step or Median respectively
#' @param yuenbt \code{TRUE} or \code{FALSE} (default), use the Yuen's
#'   bootstrap method
#' @param nboot a number (default: 599) specifying the number of bootstrap
#'   samples to use when using the bootstrap method
#' @param md \code{TRUE} or \code{FALSE} (default), provide the mean
#'   difference
#' @param ci \code{TRUE} or \code{FALSE} (default), provide a 95\% confidence
#'   interval on the mean difference
#' @param es \code{TRUE} or \code{FALSE} (default), provide the effect-size
#' @param esci \code{TRUE} or \code{FALSE} (default), provide a 95\%
#'   confidence interval on the effect-size
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$ttest} \tab \tab \tab \tab \tab the table of t-test results \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$ttest$asDF}
#'
#' \code{as.data.frame(results$ttest)}
#'
#' @export
rttestIS <- function(
    data,
    deps,
    group,
    yuen = TRUE,
    tr = 0.2,
    mest = FALSE,
    method = "mom",
    yuenbt = FALSE,
    nboot = 599,
    md = FALSE,
    ci = FALSE,
    es = FALSE,
    esci = FALSE) {

    if ( ! requireNamespace("jmvcore", quietly=TRUE))
        stop("rttestIS requires jmvcore to be installed (restart may be required)")

    if ( ! missing(deps)) deps <- jmvcore::resolveQuo(jmvcore::enquo(deps))
    if ( ! missing(group)) group <- jmvcore::resolveQuo(jmvcore::enquo(group))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(deps), deps, NULL),
            `if`( ! missing(group), group, NULL))

    for (v in group) if (v %in% names(data)) data[[v]] <- as.factor(data[[v]])

    options <- rttestISOptions$new(
        deps = deps,
        group = group,
        yuen = yuen,
        tr = tr,
        mest = mest,
        method = method,
        yuenbt = yuenbt,
        nboot = nboot,
        md = md,
        ci = ci,
        es = es,
        esci = esci)

    analysis <- rttestISClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}

