% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penvs_bgExtent.R
\name{penvs_bgExtent}
\alias{penvs_bgExtent}
\title{penvs_bgExtent Generate background extent}
\usage{
penvs_bgExtent(occs, bgSel, bgBuf, logger = NULL, spN = NULL)
}
\arguments{
\item{occs}{data frame of cleaned or processed occurrences obtained from
components occs: Obtain occurrence data or, poccs: Process occurrence data.}

\item{bgSel}{character. Method of background building. Must be one of three
options: 'bounding box' , 'point buffers' or ' minimum convex polygon'.}

\item{bgBuf}{numeric. Buffer distance in degrees to be used in the building
of the background area.}

\item{logger}{Stores all notification messages to be displayed in the Log
Window of Wallace GUI. Insert the logger reactive list here for running in
shiny, otherwise leave the default NULL.}

\item{spN}{data frame of cleaned occurrences obtained from component occs:
Obtain occurrence data. Used to obtain species name for logger messages.}
}
\value{
A SpatialPolygons object that contains all occurrences from occs
}
\description{
This function generates a background area according to a user-
  provided method.
}
\details{
This function is used in the select study region component. Here,
  the user can select between three methods ('bounding box', 'point buffers'
  or ' minimum convex polygon') to determine the background extent based on the
  observed occurrences. The function returns a SpatialPolygonsDataFrame
  object of the desired extent.
}
\examples{
occs <- read.csv(system.file("extdata/Bassaricyon_alleni.csv",
                 package = "wallace"))[, 2:3]
occs$occID <- 1:nrow(occs)
bgExt <- penvs_bgExtent(occs, bgSel = 'bounding box', bgBuf = 0.5)

}
\seealso{
\code{\link{penvs_userBgExtent}}, \code{\link{penvs_drawBgExtent}},
  \code{\link{penvs_bgMask}} , \code{\link{penvs_bgSample}}
}
\author{
Jamie Kass <jamie.m.kass@gmail.com>

Gonzalo E. Pinilla-Buitrago <gepinillab@gmail.com>

Bethany A. Johnson <bjohnso005@citymail.cuny.edu>
}
