% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{computeMAIE}
\alias{computeMAIE}
\title{Mean Absolute Imputation Error}
\usage{
computeMAIE(x.miss, x.impute, x.true)
}
\arguments{
\item{x.miss}{a \code{matrix},  having missing values}

\item{x.impute}{an imputed data \code{matrix}. Note that it should not contain any missing values.}

\item{x.true}{complete/true data \code{matrix}. Note that it should not contain any missing values.}
}
\value{
value of MSIE
}
\description{
This function computes the mean absolute imputation error for a given complete/true data matrix,
imputed data matrix and the data matrix with missing values.
}
\examples{
  set.seed(3)
  x.true = matrix(rnorm(100),10,10)
  ## create 10\% missing values in x
  x.miss = artifNA(x.true, 0.10)
  ## impute using wNNSel method
  x.impute = wNNSel.impute(x.miss)
  computeMAIE(x.miss, x.impute, x.true)
}
\keyword{error}

