% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artifNA.cv.R
\name{artifNA.cv}
\alias{artifNA.cv}
\title{Introduce MCAR Missing Values in a matrix for cross validation}
\usage{
artifNA.cv(x, testNA.prop = 0.1)
}
\arguments{
\item{x}{a matrix, in which missing values are to be created.}

\item{testNA.prop}{proportion of missing values}
}
\value{
a list contatining a matrix with artifical missing values, removed indices and the provided x matrix
}
\description{
This function introduces additional missing values in a missing data matrix artificially.
The missing values are introduced under missing completely at random (MCAR) mechanism.
}
\examples{
 set.seed(3)
 x = matrix(rnorm(100),10,10)
 ## create 10\% missing values in x
 x.miss<- artifNA(x, 0.10)
 ## create another 10\% missing values in x
 x.miss.cv<- artifNA.cv(x, 0.10)
 summary(x.miss)
 summary(x.miss.cv)
}
\seealso{
\code{\link{cv.wNNSel}}
}
\keyword{NA}
\keyword{cross-validation}

