\name{grid.vwXspline}
\alias{grid.vwXspline}
\alias{vwXsplineGrob}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Draw a variable-width X-spline.
}
\description{
  Draw a variable-width X-spline where the main line is described
  by x/y control points
  and the width describes offset control points.
}
\usage{
vwXsplineGrob(x, y, w, default.units="npc", shape=1,
              open=TRUE, repEnds=TRUE, angle="perp",
              lineend="butt", mitrelimit=4,
              render=vwPath(),
              gp=gpar(fill="black"), name=NULL, debug=FALSE)
grid.vwXspline(...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{A numeric vector or unit describing x-locations.}
  \item{y}{A numeric vector or unit describing y-locations.}
  \item{w}{A numeric vector or unit describing widths at each location,
    or a width specification generated by \code{\link{widthSpec}}.}
  \item{default.units}{The units used if \code{x} or \code{y} are
    numeric vectors.}
  \item{shape}{A numeric value (or one per location) that controls
    the shape of the X-spline curve relative to the locations.}
  \item{open}{A boolean indicating whether to connect the last location
    back to the first location to produce a closed line.}
  \item{repEnds}{A logical indicating whether to replicate the
    first and last control points (so that the X-spline starts and
    ends at the first and last control points).  Can also be the
    special value \code{"extend"}, in which case the first and last
    control segments are extended (and the resulting X-spline is
    a little curvier at the ends).}
  \item{angle}{Either \code{"perp"} or a numeric value describing a
    fixed orientation for the line width.}
  \item{lineend}{The line ending style; one of \code{"round"},
    \code{"mitre"}, \code{"butt"}, or \code{"square"}.}
  \item{mitrelimit}{A numeric that controls when a mitre join is
    converted to a bevel join or a mitre ending
    is converted to a square ending.}
  \item{render}{A function that is used to render the outline of the path
    that is generated for the variable-width line.}
  \item{gp}{A set of graphical parameters; see \code{\link{gpar}}.}
  \item{name}{A name for the grob generated for the variable-width
    line.}
  \item{debug}{A logical indicating whether to produce graphical
    debugging output.}
  \item{\dots}{
    Arguments passed to \code{vwXsplineGrob}.
  }
}
\details{
  See \code{\link{grid.xspline}} for more about the behaviour of X-splines.
}
\value{
  \code{grid.vwXspline} is used for its side-effect of drawing a
  variable-width
  line;  \code{vwXsplineGrob} returns a \code{"vwXsplineGrob"} object.
}
\author{
  Paul Murrell
}
\seealso{
  \code{\link{grid.xspline}},
  \code{\link{grid.vwline}},
  \code{\link{grid.vwXspline}},
  \code{\link{grid.brushXspline}},
  \code{\link{grid.offsetXspline}}
}
\examples{
grid.newpage()
x <- c(.2, .4, .6, .8)
y <- c(-.05, .05, -.05, .05)
w <- unit(c(2, 4, 6, 8), "mm")
grid.vwXspline(x, y + .8, w)
grid.vwXspline(x, y + .6, w,
               angle=45)
grid.vwXspline(x, y + .4, w,
               lineend="round")
grid.vwXspline(x, y + .2, w,
               gp=gpar(col="black"), debug=TRUE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ aplot }% use one of  RShowDoc("KEYWORDS")
