% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_prep.R
\name{prep_df_summ}
\alias{prep_df_summ}
\title{Prepare summarized dataframe}
\usage{
prep_df_summ(df, variables, y)
}
\arguments{
\item{df}{A dataframe to be summarized}

\item{variables}{A character vector specifying the columns to be grouped by}

\item{y}{A character vector specifying the column to be summarized}
}
\value{
A summarized dataframe
}
\description{
This function prepares a summarized dataframe based on provided variables and a y-variable.
The function groups the dataframe by the provided variables, summarizes the y-variable,
and counts the number of observations per group.
}
\examples{
df <- data.frame(
id = c(1, 1, 2, 2),
group = c("A", "A", "B", "B"),
value = c(2, 4, 6, 8)
)
df_summ <- prep_df_summ(df, c("id", "group"), "value")
}
