% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_bind.R
\name{bind_both}
\alias{bind_both}
\title{Bind both}
\usage{
bind_both(
  dfLeft,
  dfRight,
  id = "bench",
  y_left = NULL,
  y_right = NULL,
  facet_var = rlang::sym("VIS_Groep"),
  facet_name_var = rlang::sym("VIS_Groep_naam")
)
}
\arguments{
\item{dfLeft}{A dataframe to be combined}

\item{dfRight}{A dataframe to be combined}

\item{id}{An identifier string specifying the type of operation}

\item{y_left}{A character vector specifying the column to be used for the left dataframe}

\item{y_right}{A character vector specifying the column to be used for the right dataframe}

\item{facet_var}{A symbol specifying the variable to be used for faceting}

\item{facet_name_var}{A symbol specifying the variable to be used for the facet name}
}
\value{
A dataframe obtained by binding dfLeft and dfRight, with additional transformations applied
}
\description{
This function binds two dataframes row-wise and performs additional manipulations depending on the 'type'.
The function also reorders the factor levels of the specified facet variable.
}
\examples{
df1 <- data.frame(x = 1:5, y = rnorm(5), VIS_Groep_naam = "One")
df2 <- data.frame(x = 6:10, y = rnorm(5), VIS_Groep_naam = "Two")
df_both <- bind_both(df1, df2, id = "test",
                     y_left = "y", y_right = "y",
                     facet_var = rlang::sym("x"))
}
