% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/release.R
\name{vsts_get_release_defs}
\alias{vsts_get_release_defs}
\title{Azure DevOps Project Release Definition Information}
\usage{
vsts_get_release_defs(domain, project, auth_key, quiet = FALSE)
}
\arguments{
\item{domain}{The name of the Azure DevOps organization.}

\item{project}{the name of the project in \code{domain} to look at}

\item{auth_key}{authentication key generated by using \code{\link{vsts_auth_key}}}

\item{quiet}{logical whether want general running information from printing. Any
issue with the API call will still show up if set to \code{TRUE}}
}
\description{
These functions will allow you to scrape release definition information from Azure DevOps.
}
\details{
For more information about release definition API calls check
\url{https://docs.microsoft.com/en-us/rest/api/azure/devops/release/releases}.
}
\examples{
\dontrun{
# Add in own details to get a non-NULL output
auth_key <- vsts_auth_key("<username>", "<password>")
vsts_get_release_defs("domain", "project", auth_key)
}

}
