% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workitem.R
\name{vsts_get_workitems}
\alias{vsts_get_workitems}
\alias{vsts_get_workitem}
\title{Azure DevOps Project Get Work Items}
\usage{
vsts_get_workitems(domain, project, auth_key, id, query = list())

vsts_get_workitem(domain, project, auth_key, id)
}
\arguments{
\item{domain}{The name of the Azure DevOps organization.}

\item{project}{Project ID or project name}

\item{auth_key}{authentication key generated by using \code{\link{vsts_auth_key}}}

\item{id}{ID of the work item to retrieve}

\item{query}{a list of extra parameters that can be sent to the API call:
\describe{
\item{\code{ids}}{[character] a comma-separated list of up to 200 IDs of the work items to get}
\item{\code{fields}}{[character] a comma-separated list of up to 100 fields to get with each work item.
If not specified, all fields with values are returned. Calculated fields such as Attached File Count must be specifically
queried for using this parameter.}
\item{\code{asOf}}{[Date] gets the work items as they existed at this time}
\item{\code{ErrorPolicy}}{[character] determines if the call will throw an error when encountering a work item (default behavior)
that doesn't exist (\code{throw}) or simply omit it (\code{omit})}
}}
}
\description{
These functions will allow you to scrape work item information from a particular Azure DevOps project.
}
\details{
For more information about work item API calls check
\url{https://docs.microsoft.com/en-us/rest/api/azure/devops/wit/work-items}.
}
