% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdc_schulze.R
\name{cdc_schulze}
\alias{cdc_schulze}
\title{Schulze Method}
\usage{
cdc_schulze(x, allow_dup = TRUE, min_valid = 1)
}
\arguments{
\item{x}{it accepts the following types of input:
1st, it can be an object of class \code{vote}. 
2nd, it can be a user-given Condorcet matrix, 
3rd, it can be a result of another Condorcet method, 
which is of class \code{condorcet}.}

\item{allow_dup}{whether ballots with duplicated score values 
are taken into account. Default is TRUE.}

\item{min_valid}{default is 1. If the number of valid entries of 
a ballot is less than this value, it will not be used.}
}
\value{
a \code{condorcet} object, which is essentially 
a list.
\itemize{
  \item (1) \code{call} the function call.
  \item (2) \code{method} the counting method.
  \item (3) \code{candidate} candidate names.
  \item (4) \code{candidate_num} number of candidate.
  \item (5) \code{ballot_num} number of ballots in x. When 
x is not a \code{vote} object, it may be NULL.
  \item (6) \code{valid_ballot_num} number of ballots that are 
actually used to compute the result. When 
x is not a \code{vote} object, it may be NULL.
  \item (7) \code{winner} the winners, may be NULL.
  \item (8) \code{input_object} the class of x. 
  \item (9) \code{cdc} the Condorcet matrix which is actually used.
  \item (10) \code{dif} the score difference matrix. When 
x is not a \code{vote} object, it may be NULL.
  \item (11) \code{binary} win and loss recorded with 1 (win), 
0 (equal) and -1 (loss).
  \item (12) \code{summary_m} times of win (1), equal (0) 
and loss (-1).
  \item (13) \code{other_info} a list of 2 elements. The 1st is the strength 
comparison matrix. The 2nd is the strength comparison matrix in binary 
mode, 1 for win, 0 for else.
}
}
\description{
Schulze method is essentially a widest path problem.
With the Condorcet matrix, we must find the so called 
the strongest path a > b > c > d, and the winner is a. 
The strength of a path is the strength of its weakest link.
}
\examples{
raw <- list2ballot(
    x = list(
        c('a', 'c', 'b', 'e', 'd'), 
        c('a', 'd', 'e', 'c', 'b'), 
        c('b', 'e', 'd', 'a', 'c'), 
        c('c', 'a', 'b', 'e', 'd'), 
        c('c', 'a', 'e', 'b', 'd'), 
        c('c', 'b', 'a', 'd', 'e'), 
        c('d', 'c', 'e', 'b', 'a'), 
        c('e', 'b', 'a', 'd', 'c')
    ), 
    n = c(5, 5, 8, 3, 7, 2, 7, 8)
)
vote <- create_vote(raw, xtype = 3, candidate = c('a', 'b', 'c', 'd', 'e'))
win1 <- cdc_simple(vote) # no winner
win2 <- cdc_schulze(vote) # winner is e
win2 <- cdc_schulze(win1)
}
\references{
\itemize{
  \item Schulze, M. 2010. A new monotonic, 
clone-independent, reversal symmetric, 
and Condorcet-consistent single-winner election method. 
Social Choice and Welfare, 36(2), 267-303.
}
}
