% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collect.thread.mastodon.R
\name{Collect.thread.mastodon}
\alias{Collect.thread.mastodon}
\title{Collect posts data from mastodon threads}
\usage{
\method{Collect}{thread.mastodon}(
  credential,
  endpoint,
  threadUrls,
  ...,
  writeToFile = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{credential}{A \code{credential} object generated from \code{Authenticate} with class name \code{"mastodon"}.}

\item{endpoint}{API endpoint.}

\item{threadUrls}{Character vector. Mastodon thread post urls to collect data from.}

\item{...}{Additional parameters passed to function. Not used in this method.}

\item{writeToFile}{Logical. Write collected data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information about the data collection. Default is \code{TRUE}.}
}
\value{
A \code{tibble} object with class names \code{"datasource"} and \code{"mastodon"}.
}
\description{
Collects public posts for one or more specified mastodon conversation threads and structures
the data into a dataframe with the class names \code{"datasource"} and \code{"mastodon"}.
}
\examples{
\dontrun{
# post urls to collect threads from
threadUrls <- c("https://mastodon.social/@xxxxxx/xxxxxxxxx")

mastodonData <- Authenticate("mastodon") |>
  Collect(threadUrls = threadUrls, writeToFile = TRUE)
}

}
