% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddText.R
\name{AddText.actor.reddit}
\alias{AddText.actor.reddit}
\title{Add columns containing text data to reddit actor network dataframes}
\usage{
\method{AddText}{actor.reddit}(net, data, cleanText = FALSE, ..., writeToFile = FALSE, verbose = TRUE)
}
\arguments{
\item{net}{A named list of dataframes \code{nodes} and \code{edges} generated by \code{Create}.}

\item{data}{A dataframe generated by \code{Collect}.}

\item{cleanText}{Logical. Simple removal of problematic characters for XML 1.0 standard. Implemented to prevent
reddit specific XML control character errors when generating graphml files. Default is \code{FALSE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}

\item{writeToFile}{Logical. Write data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information. Default is \code{TRUE}.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges} including columns
containing text data.
}
\description{
Add columns containing text data to reddit actor network dataframes
}
\examples{
\dontrun{
# add text to an actor network ignoring references to actors at the beginning of
# comment text
net_actor <- collect_rd |>
  Create("actor") |>
  AddText(collect_rd)

# network
net_actor$nodes
net_actor$edges
}

}
