% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vt_nodes.R
\name{vt_add_nodes}
\alias{vt_add_nodes}
\title{vt_add_nodes}
\usage{
vt_add_nodes(node, refnode, node_names, colors = NULL, weights = NULL,
  codes = NULL)
}
\arguments{
\item{node}{a node object}

\item{refnode}{name of the reference node}

\item{node_names}{new node names}

\item{colors}{optionally a vector of colors matching the length of \code{node_names}}

\item{weights}{optionally a vector of weights matching the length of \code{node_names}}

\item{codes}{optionally a vector of short labels matching the length of \code{node_names}}
}
\value{
a Node object
}
\description{
add (sub)nodes to a node generated by \code{\link{vt_create_node}} or returned
from  \code{\link{vt_add_nodes}}
}
\examples{
n <- vt_create_node("Total")
n <- vt_add_nodes(n, refnode="Total",node_names=c("Asia","Europe"), colors=c("red","blue"))
n <- vt_add_nodes(n, refnode="Asia",node_names=c("China","Thailand"),
  weights=c(0.5, 0.8), codes=c("CN","TH"))
n <- vt_add_nodes(n, refnode="Europe",node_names=c("Netherlands","Austria"),
  weights=c(0.9, 1.1), codes=c("NL","AT"))
print(n, "weight", "code", "color")
}
