% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStats.R
\name{getStats}
\alias{getStats}
\title{Get Summary AE Statistics}
\usage{
getStats(dfAE, dfDemog, settings, stat = "Risk Ratio")
}
\arguments{
\item{dfAE}{Adverse events dataset structured as 1 record per adverse event
per subject}

\item{dfDemog}{Subject-level dataset}

\item{settings}{Named list of settings (see examples below for standard list)}

\item{stat}{Statistic to calculate for AE plot. Options are risk ratio ("RR"
or "Risk Ratio"), risk difference ("RD" or "Risk Difference"). Defaults to
"Risk Ratio".}
}
\value{
a data frame of group-wise statistics for use in the volcano plot
}
\description{
Compares reference and comparison groups to calculate group-wise metrics and p-values for use in AE volcano plot.
}
\examples{
settings<-list(
  stratification_col="AEBODSYS",
  group_col="ARM",
  reference_group="Placebo",
  comparison_group="Xanomeline High Dose",
  id_col="USUBJID"
)
getStats(dfAE=safetyData::adam_adae, dfDemog = safetyData::adam_adsl, settings)

}
