% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm0.R
\name{rm0}
\alias{rm0}
\title{Compress zeros.}
\usage{
rm0(y)
}
\arguments{
\item{y}{A vector or time series.}
}
\value{
Vector with n zeros.
}
\description{
Transforms \code{n} sets of \code{m>n} zeros (alternated with sets of non zeros) into \code{n} sets of \code{n} zeros.
}
\examples{
library(voice)

(v0 <- c(1:20,rep(0,10)))
(r0 <- rm0(v0))
length(v0)
length(r0)
sum(v0 == 0)

(v1 <- c(rep(0,10),1:20))
(r1 <- rm0(v1))
length(r1)

(v2 <- rep(0,10))
(r2 <- rm0(v2))
length(r2)

(v3 <- c(0:10))
(r3 <- rm0(v3))
length(r3)

(v4 <- c(rep(0,10), 1:10, rep(0,5), 10:20, rep(0,10)))
(r4 <- rm0(v4))
length(r4)
sum(v4 == 0)
}
