% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{vkApply}
\alias{vkApply}
\title{Apply a method over a vector of objects}
\usage{
vkApply(objs, method)
}
\arguments{
\item{objs}{A vector of objects}

\item{method}{The function to be applied to each element of `objs`}
}
\description{
Returns a data frame of the same number of rows as length of `objs`, each element of which is the
result of applying `method` to the corresponding element of `objs`
}
\examples{
\dontrun{
 users <- vkApply(c("",1234567), function(user) getUsers(user, fields="sex"))
 countries <- vkApply(c(2,5122182,1906578), getCountryByCityId)
}
}
