% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{usersSearch}
\alias{usersSearch}
\title{Returns a list of users matching the search criteria}
\usage{
usersSearch(
  q = "",
  sort = "",
  offset = "",
  count = "20",
  fields = "",
  city = "",
  country = "",
  hometown = "",
  university_country = "",
  university = "",
  university_year = "",
  university_faculty = "",
  university_chair = "",
  sex = "",
  status = "",
  age_from = "",
  age_to = "",
  birth_day = "",
  birth_month = "",
  birth_year = "",
  online = "",
  has_photo = "",
  school_country = "",
  school_city = "",
  school_class = "",
  school = "",
  school_year = "",
  religion = "",
  interests = "",
  company = "",
  position = "",
  group_id = "",
  from_list = "",
  flatten = FALSE,
  v = getAPIVersion()
)
}
\arguments{
\item{q}{Search query string (e.g., Vasya Babich)}

\item{sort}{Sort order: 1 - by date registered; 0 - by rating}

\item{offset}{Offset needed to return a specific subset of users}

\item{count}{Number of users to return}

\item{fields}{Profile fields to return}

\item{city}{City ID}

\item{country}{Country ID}

\item{hometown}{City name in a string}

\item{university_country}{ID of the country where the user graduated}

\item{university}{ID of the institution of higher education}

\item{university_year}{Year of graduation from an institution of higher education}

\item{university_faculty}{Faculty ID}

\item{university_chair}{Chair ID}

\item{sex}{1 - female; 2 - male; 0 - any (default)}

\item{status}{Relationship status: 1 - Not married; 2 - In a relationship; 3 - Engaged; 4 - Married; 5 - It's complicated; 6 - Actively searching; 7 - In love}

\item{age_from}{Minimum age}

\item{age_to}{Maximum age}

\item{birth_day}{Day of birth}

\item{birth_month}{Month of birth}

\item{birth_year}{Year of birth}

\item{online}{1 - online only; 0 - all users}

\item{has_photo}{1 - with photo only; 0 - all users}

\item{school_country}{ID of the country where users finished school}

\item{school_city}{ID of the city where users finished school}

\item{school_class}{Positive number}

\item{school}{ID of the school}

\item{school_year}{School graduation year}

\item{religion}{Users' religious affiliation}

\item{interests}{Users' interests}

\item{company}{Name of the company where users work}

\item{position}{Job position}

\item{group_id}{ID of a community to search in communities}

\item{from_list}{List of comma-separated words}

\item{flatten}{Automatically flatten nested data frames into a single non-nested data frame}

\item{v}{Version of API}
}
\description{
Returns a list of users matching the search criteria
}
