% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messages.R
\name{messagesSend}
\alias{messagesSend}
\title{Sends a message.}
\usage{
messagesSend(
  user_id,
  random_id = "",
  peer_id = "",
  domain = "",
  chat_id = "",
  user_ids = "",
  message = "",
  lat = "",
  long = "",
  attachment = "",
  forward_messages = "",
  sticker_id = "",
  v = getAPIVersion()
)
}
\arguments{
\item{user_id}{User ID (by default — current user).}

\item{random_id}{Unique identifier to avoid resending the message.}

\item{peer_id}{Destination ID.}

\item{domain}{User's short address (for example, illarionov).}

\item{chat_id}{ID of conversation the message will relate to.}

\item{user_ids}{IDs of message recipients (if new conversation shall be started).}

\item{message}{Text of the message (required if attachments is not set).}

\item{lat}{Geographical latitude of a check-in, in degrees (from -90 to 90).}

\item{long}{Geographical longitude of a check-in, in degrees (from -180 to 180).}

\item{attachment}{List of objects attached to the message, separated by commas, in the following format: <type><owner_id>_<media_id>

<type> — Type of media attachment:
\itemize{
 \item photo - photo
 \item video - video
 \item audio - audio
 \item doc - document
 \item wall - wall post
}

<owner_id> — ID of the media attachment owner.

<media_id> — media attachment ID.}

\item{forward_messages}{ID of forwarded messages, separated with a comma. Listed messages of the sender will be shown in the message body at the recipient's.}

\item{sticker_id}{Sticker id.}

\item{v}{Version of API.}
}
\description{
Sends a message.
}
