% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{getGroupsMembersExecute}
\alias{getGroupsMembersExecute}
\title{Returns a list of community members}
\usage{
getGroupsMembersExecute(
  group_id = "",
  sort = "",
  offset = 0,
  count = 0,
  fields = "",
  filter = "",
  flatten = FALSE,
  progress_bar = FALSE,
  v = getAPIVersion()
)
}
\arguments{
\item{group_id}{ID or screen name of the community}

\item{sort}{Sort order. Available values: id_asc, id_desc, time_asc, time_desc. time_asc and time_desc are availavle only if the method is called by the group's moderator}

\item{offset}{Offset needed to return a specific subset of community members}

\item{count}{Number of community members to  (0 - get all community members)}

\item{fields}{List of additional fields to be returned}

\item{filter}{friends - only friends in this community will be returned; unsure - only those who pressed 'I may attend' will be returned (if it's an event)}

\item{flatten}{Automatically flatten nested data frames into a single non-nested data frame}

\item{progress_bar}{Display progress bar}

\item{v}{Version of API}
}
\description{
Returns a list of community members
}
\examples{
\dontrun{
members <- getGroupsMembersExecute(1, fields='sex,bdate,city', progress_bar = TRUE)
}
}
