% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-vis-cor.R
\name{data-vis-cor}
\alias{data-vis-cor}
\alias{data_vis_cor}
\alias{data_vis_cor.default}
\alias{data_vis_cor.data.frame}
\alias{data_vis_cor.grouped_df}
\title{Return data used to create vis_cor plot}
\usage{
data_vis_cor(x, ...)

\method{data_vis_cor}{default}(x, ...)

\method{data_vis_cor}{data.frame}(
  x,
  cor_method = "pearson",
  na_action = "pairwise.complete.obs",
  ...
)

\method{data_vis_cor}{grouped_df}(x, ...)
}
\arguments{
\item{x}{data.frame}

\item{...}{extra arguments (currently unused)}

\item{cor_method}{correlation method to use, from \code{cor}: "a character
string indicating which correlation coefficient (or covariance) is to be
computed. One of "pearson" (default), "kendall", or "spearman": can be
abbreviated."}

\item{na_action}{The method for computing covariances when there are missing
values present. This can be "everything", "all.obs", "complete.obs",
"na.or.complete", or "pairwise.complete.obs" (default). This option is
taken from the \code{cor} function argument \code{use}.}
}
\value{
data frame

tidy dataframe of correlations
}
\description{
Return data used to create vis_cor plot

Create a tidy dataframe of correlations suitable for plotting
}
\examples{
data_vis_cor(airquality)

\dontrun{
#return vis_dat data for each group
library(dplyr)
airquality \%>\%
  group_by(Month) \%>\%
  data_vis_cor()
}
data_vis_cor(airquality)

}
