% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visa.R
\docType{package}
\name{visa}
\alias{visa-package}
\alias{visa}
\title{visa: Vegetation Imaging Spectroscopy Analyzer}
\description{
Provides easy-to-use tools for data analysis and visualization for hyperspectral remote sensing (also known as imaging spectroscopy), with a particular focus on vegetation hyperspectral data analysis. It consists of a set of functions, ranging from the organization of hyperspectral data in the proper data structure for spectral feature selection, calculation of vegetation index, multivariate analysis, as well as to the visualization of spectra and results of analysis in the 'ggplot2' style.
}
\details{
The visa package provides a set of functions for hyperspectral data analysis,
with the main purpose of simplifying the analysis and interpretation of
vegetation spectral data.

It implement two categories of important functions, including its own function
and also some built on other r packages.

\itemize{
\item vegetation indices, and
\item multivariate analyses....
}

To know more about visa, check the vignettes:
`browseVignettes("visa")`
}
\section{Vegetation Indices}{

Support the calculation of vegetation indices from literature, as well as
creation of new indices.
}

\section{Multivariate analysis}{

... not implemented yet
The multivariate analysis use the Spectra.Dataframe format.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/kang-yu/visa}
  \item Report bugs at \url{https://github.com/kang-yu/visa/issues}
}

}
\author{
Kang Yu
}
\keyword{internal}
