% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm.nsr.R
\name{cm.nsr}
\alias{cm.nsr}
\title{Selecting the best 2-Band combinations for Normalized Simple Ratio (NSR)}
\usage{
cm.nsr(S, x, w = wavelength(S), w.unit = NULL, cm.plot = FALSE)
}
\arguments{
\item{S}{A matrix of spectral data, where each row is a spectrum across all spectral bands.}

\item{x}{A numeric vector (e.g., a vegetation variable).}

\item{w}{A numeric vector of wavelengths; by default it is derived using \code{wavelength(S)}.}

\item{w.unit}{A character string specifying the unit of wavelengths (default is \code{NULL}).}

\item{cm.plot}{Logical. If \code{TRUE}, the correlation coefficient matrix is plotted.}
}
\value{
\item{cm}{A correlation coefficient matrix with squared Pearson correlation values.}
}
\description{
This function develops an optimization algorithm based on correlation analysis between the spectral matrix \code{spectra} and the
vegetation variable of interest \code{x}. It determines the best spectral band combinations (i, j) of the full spectrum that are most predictive for \code{x}.
}
\details{
For every possible pair of distinct bands (i, j), the function calculates
\deqn{ \mathrm{NSR} = \frac{R_j - R_i}{R_j + R_i} }
and then computes the squared Pearson correlation (\eqn{R^2}) between \code{x} and the resulting NSR values.

If the two bands are identical or the standard deviation of computed \code{VI} (for a given band combination) is zero, the correlation is set to 0,
thereby avoiding warnings.
}
\examples{
\dontrun{
  library(visa)
  data(NSpec.DF)
  X <- NSpec.DF$spectra[, seq(1, ncol(NSpec.DF$spectra), 5)]  # resampled to 5 nm steps
  y <- NSpec.DF$N  # nitrogen
  cm <- cm.nsr(X, y, cm.plot = TRUE)
}

}
\seealso{
\code{\link{cor}}
}
