% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visa.est.R
\name{visa.est}
\alias{visa.est}
\title{Valid Improved Sparsity A-Learning for Optimal Treatment Decision}
\usage{
visa.est(
  y,
  x,
  a,
  IC = c("BIC", "CIC", "VIC"),
  kap = NULL,
  lambda.list = exp(seq(-3.5, 2, 0.1)),
  refit = TRUE
)
}
\arguments{
\item{y}{Vector of response (the larger the better)}

\item{x}{Matrix of model covariates.}

\item{a}{Vector of treatment received. It is a 0/1 index vector representing the subject is in control/treatment group. For details see Example section.}

\item{IC}{Information criterion used in determining the regularization parameter. Users can choose among \code{BIC}, \code{CIC} and \code{VIC}.}

\item{kap}{The model complexity penalty used in the information criteria. By default, kappa = 1 if BIC or CIC is used and kap = 4 if VIC is used.}

\item{lambda.list}{A list of regularization parameter values. Default is exp(seq(-3.5, 2, 0.1))}

\item{refit}{logical. If \code{TRUE}, the coefficients should be refitted using A-learning estimating equation. Default is \code{TRUE}.}
}
\value{
an object of class "visa" is a list containing at least the following components:
\item{beta.est}{A vector of coefficients of optimal treatment regime.}
\item{pi.est}{A vector of estimated propensity score.}
\item{h.est}{A vector of estimated baseline function.}
}
\description{
Valid Improved Sparsity A-Learning for Optimal Treatment Decision
}
\details{
See the paper provided in Reference section.
}
\examples{
data(visa_SimuData)
y = visa_SimuData$y
a = visa_SimuData$a
x = visa_SimuData$x
# estimation
result <- visa.est(y, x, a, IC = "BIC", lambda.list = c(0.1, 0.5))
result$beta.est
result$pi.est
result$h.est
}
\references{
{Shi, C., Fan, A., Song, R. and Lu, W. (2018) High-Dimensional A-Learing for Optimal Dynamic Treatment Regimes. \emph{Annals of Statistics,} \bold{ 46:} 925-957. DOI:10.1214/17-AOS1570}

{Shi, C.,Song, R. and Lu, W. (2018) Concordance and Value Information Criteria for Optimal Treatment Decision. \emph{Annals of Statistics,} \bold{ 49:} 49-75. DOI:10.1214/19-AOS1908}

{Zhan, Z. and Zhang, J. (2022+) Valid Improved Sparsity A-learning for Optimal Treatment Decision. Under review.}
}
