% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_vin.R
\name{check_vin}
\alias{check_vin}
\title{Verify VIN Validity}
\usage{
check_vin(vin, guess = FALSE)
}
\arguments{
\item{vin}{A character vector of VINs to check. Wildcards (e.g. *) are NOT allowed.}

\item{guess}{Logical. Should values for illegal characters be guessed?}
}
\value{
A logical vector of same length as the input vector.
}
\description{
Examines provided VINs for valid length, characters, and check digit.
}
\examples{
vins <- c("WDBEA30D3HA391172", "3VWLL7AJ9BM053541")
check_vin(vins)
}
