% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictiveness_measure.R
\name{predictiveness_measure}
\alias{predictiveness_measure}
\title{Construct a Predictiveness Measure}
\usage{
predictiveness_measure(
  type = character(),
  y = numeric(),
  a = numeric(),
  fitted_values = numeric(),
  cross_fitting_folds = rep(1, length(fitted_values)),
  full_y = NULL,
  nuisance_estimators = list(),
  C = rep(1, length(y)),
  Z = NULL,
  folds_Z = cross_fitting_folds,
  ipc_weights = rep(1, length(y)),
  ipc_fit_type = "SL",
  ipc_eif_preds = numeric(),
  ipc_est_type = "aipw",
  scale = "identity",
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{type}{the measure of interest (e.g., "accuracy", "auc", "r_squared")}

\item{y}{the outcome of interest}

\item{a}{the exposure of interest (only used if \code{type = "average_value"})}

\item{fitted_values}{fitted values from a regression function using the
observed data (may be within a specified fold, for cross-fitted estimates).}

\item{cross_fitting_folds}{folds for cross-fitting, if used to obtain the
fitted values. If not used, a vector of ones.}

\item{full_y}{the observed outcome (not used, defaults to \code{NULL}).}

\item{nuisance_estimators}{a list of nuisance function estimators on the
observed data (may be within a specified fold, for cross-fitted estimates).
For the average value measure: an estimator of the optimal treatment rule (\code{f_n}); an estimator of the
propensity score under the estimated optimal treatment rule (\code{g_n}); and an estimator
of the outcome regression when treatment is assigned according to the estimated optimal rule (\code{q_n}).}

\item{C}{the indicator of coarsening (1 denotes observed, 0 denotes
unobserved).}

\item{Z}{either \code{NULL} (if no coarsening) or a matrix-like object
containing the fully observed data.}

\item{folds_Z}{either the cross-validation folds for the observed data
(no coarsening) or a vector of folds for the fully observed data Z.}

\item{ipc_weights}{weights for inverse probability of coarsening (IPC)
(e.g., inverse weights from a two-phase sample) weighted estimation.
Assumed to be already inverted.
(i.e., ipc_weights = 1 / [estimated probability weights]).}

\item{ipc_fit_type}{if "external", then use \code{ipc_eif_preds}; if "SL",
fit a SuperLearner to determine the IPC correction to the efficient
influence function.}

\item{ipc_eif_preds}{if \code{ipc_fit_type = "external"}, the fitted values
from a regression of the full-data EIF on the fully observed
covariates/outcome; otherwise, not used.}

\item{ipc_est_type}{IPC correction, either \code{"ipw"} (for classical
inverse probability weighting) or \code{"aipw"} (for augmented inverse
probability weighting; the default).}

\item{scale}{if doing an IPC correction, then the scale that the correction
should be computed on (e.g., "identity"; or "logit" to logit-transform,
apply the correction, and back-transform).}

\item{na.rm}{logical; should \code{NA}s be removed in computation?
(defaults to \code{FALSE})}

\item{...}{other arguments to SuperLearner, if \code{ipc_fit_type = "SL"}.}
}
\value{
An object of class \code{"predictiveness_measure"}, with the following
 attributes:
}
\description{
Construct a Predictiveness Measure
}
