% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{estimate_nuisances}
\alias{estimate_nuisances}
\title{Estimate nuisance functions for average value-based VIMs}
\usage{
estimate_nuisances(
  fit,
  X,
  exposure_name,
  V = 1,
  SL.library,
  sample_splitting,
  sample_splitting_folds,
  verbose,
  weights,
  cross_fitted_se,
  split = 1,
  ...
)

estimate_nuisances(
  fit,
  X,
  exposure_name,
  V = 1,
  SL.library,
  sample_splitting,
  sample_splitting_folds,
  verbose,
  weights,
  cross_fitted_se,
  split = 1,
  ...
)
}
\arguments{
\item{fit}{the fitted nuisance function estimator}

\item{X}{the covariates. If \code{type = "average_value"}, then the exposure
variable should be part of \code{X}, with its name provided in \code{exposure_name}.}

\item{exposure_name}{(only used if \code{type = "average_value"}) the name of
the exposure of interest; binary, with 1 indicating presence of the exposure and
0 indicating absence of the exposure.}

\item{V}{the number of folds for cross-fitting, defaults to 5. If
\code{sample_splitting = TRUE}, then a special type of \code{V}-fold cross-fitting
is done. See Details for a more detailed explanation.}

\item{SL.library}{a character vector of learners to pass to
\code{SuperLearner}, if \code{f1} and \code{f2} are Y and X,
respectively. Defaults to \code{SL.glmnet}, \code{SL.xgboost},
and \code{SL.mean}.}

\item{sample_splitting}{should we use sample-splitting to estimate the full and
reduced predictiveness? Defaults to \code{TRUE}, since inferences made using
\code{sample_splitting = FALSE} will be invalid for variables with truly zero
importance.}

\item{sample_splitting_folds}{the folds used for sample-splitting;
these identify the observations that should be used to evaluate
predictiveness based on the full and reduced sets of covariates, respectively.
Only used if \code{run_regression = FALSE}.}

\item{verbose}{should we print progress? defaults to FALSE}

\item{weights}{weights to pass to estimation procedure}

\item{cross_fitted_se}{should we use cross-fitting to estimate the standard
errors (\code{TRUE}, the default) or not (\code{FALSE})?}

\item{split}{the sample split to use}

\item{...}{other arguments to the estimation tool, see "See also".}
}
\value{
nuisance function estimators for use in the average value VIM:
 the treatment assignment based on the estimated optimal rule
 (based on the estimated outcome regression); the expected outcome under the
 estimated optimal rule; and the estimated propensity score.

nuisance function estimators for use in the average value VIM:
 the treatment assignment based on the estimated optimal rule
 (based on the estimated outcome regression); the expected outcome under the
 estimated optimal rule; and the estimated propensity score.
}
\description{
Estimate nuisance functions for average value-based VIMs

Estimate nuisance functions for average value-based VIMs
}
