% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viking.R
\name{viking}
\alias{viking}
\title{Viking: Variational bayesIan variance tracKING}
\usage{
viking(
  X,
  y,
  theta0,
  P0,
  hata0,
  s0,
  hatb0,
  Sigma0,
  n_iter = 2,
  mc = 10,
  rho_a = 0,
  rho_b = 0,
  learn_sigma = TRUE,
  learn_Q = TRUE,
  K = NULL,
  mode = "diagonal",
  thresh = TRUE,
  phi = logt,
  phi1 = logt1,
  phi2 = logt2
)
}
\arguments{
\item{X}{the explanatory variables}

\item{y}{the time series}

\item{theta0}{initial \code{theta}}

\item{P0}{initial \code{P}}

\item{hata0}{initial \code{hata}}

\item{s0}{initial \code{s}}

\item{hatb0}{initial \code{hatb}}

\item{Sigma0}{initial \code{Sigma}}

\item{n_iter}{(optional, default \code{2}) number of alternate steps}

\item{mc}{(optional, default \code{10}) number of Monte-Carlo samples}

\item{rho_a}{(optional, default \code{0}) learning rate of \code{a}}

\item{rho_b}{(optional, default \code{0}) learning rate of \code{b}}

\item{learn_sigma}{(optional, default \code{TRUE}) asserts the estimation of \code{a}}

\item{learn_Q}{(optional, default \code{TRUE}) asserts the estimation of \code{b}}

\item{K}{(optional, default \code{NULL}) if not \code{NULL} then it is a multiplicative
factor of the state in the state update}

\item{mode}{(optional, default \code{'diagonal'})}

\item{thresh}{(optional, default \code{TRUE})}

\item{phi}{(optional, default \code{logt})}

\item{phi1}{(optional, default \code{logt1})}

\item{phi2}{(optional, default \code{logt2})}
}
\value{
a list composed of the evolving value of all the parameters:
\code{theta_arr, P_arr, q_arr, hata_arr, s_arr, hatb_arr, Sigma_arr}
}
\description{
\code{viking} is the state-space estimation realized by Viking,
generalizing the Kalman Filter to variance uncertainty.
}
\references{
J. de Vilmarest, O. Wintenberger (2021), Viking: Variational Bayesian Variance
Tracking. <arXiv:2104.10777>
}
