% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server-side.R
\name{video-server}
\alias{video-server}
\alias{playVideo}
\alias{pauseVideo}
\alias{stopVideo}
\alias{seekVideo}
\alias{changeVideo}
\alias{updatePlaybackRate}
\title{Update video.js Server-Side}
\usage{
playVideo(id, session = getDefaultReactiveDomain())

pauseVideo(id, session = getDefaultReactiveDomain())

stopVideo(id, session = getDefaultReactiveDomain())

seekVideo(id, seek, session = getDefaultReactiveDomain())

changeVideo(id, files, format = NULL, session = getDefaultReactiveDomain())

updatePlaybackRate(id, playrate = 1, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{ID of the \code{video} to update}

\item{session}{Shiny session}

\item{seek}{Time (in seconds) to set the position of the track}

\item{files}{A vector of file paths or URLs pointing}

\item{format}{An optional list of formats of \code{video}}

\item{playrate}{Speed of playback of the video. Default is set to 1 (normal speed)}
}
\value{
Updates the the state of the specified \code{video} in the shiny application.
}
\description{
Change the state of the video player from the server.

\code{playVideo}, \code{pauseVideo} and \code{stopVideo} will all be applied to the current video.

\code{changeVideo} will update the track to the URL or file specified.

\code{updatePlaybackRate} will change how fast the video is playing.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    title = "howler.js Player",
    video(
      "https://vjs.zencdn.net/v/oceans.mp4",
      elementId = "video"
     ),
    actionButton("pause", "Pause Video")
  )

  server <- function(input, output) {
    observeEvent(input$pause, pauseVideo("video"))
  }

  runShiny(ui, server)
}

}
