% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_files.R
\name{list_files}
\alias{list_files}
\title{One row list for two distinct files}
\usage{
list_files(file1, file2)
}
\arguments{
\item{file1}{character, giving the the full file path of the first file}

\item{file2}{character, giving the the full file path of the second file}
}
\value{
Returns a tibble, \code{selected_files} with 2 columns \code{file1},
                \code{file2}
}
\description{
\code{list_files} List single file row based on the explicit parameter
files. This is a conveniency function for building same structure list for
direct two file comparison case.
}
\examples{

path1 <- "/extdata/base_files/file2_additional_rows.rtf"
file1 <- paste0(fs::path_package(path1, package = "verifyr2"))

path2 <- "/extdata/compare_files/file3_changed_rows.rtf"
file2 <- paste0(fs::path_package(path2, package = "verifyr2"))

verifyr2::list_files(file1, file2)

}
