% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_digit.R
\name{calculate_digit}
\alias{calculate_digit}
\title{calculate_digit}
\usage{
calculate_digit(number, d5, d5_p, inv_v)
}
\arguments{
\item{number}{A number you want to calculate the check digit for}

\item{d5}{The verhoeff d5 matrix. Retrievable with create_verhoeff_matrices()$d5}

\item{d5_p}{The verhoeff p matrix. Retrievable with create_verhoeff_matrices()$d5_p}

\item{inv_v}{The verhoeff inv matrix. Retrievable with create_verhoeff_matrices()$inv_v}
}
\value{
A single integer
}
\description{
Calculates a single Verhoeff Check Digit. This function is exported, but it would usually
be called from one of the `verhoeff_*` wrapper functions
}
\examples{
dat <- verhoeff::create_verhoeff_matrices()
calculate_digit(5, dat$d5, dat$d5_p, dat$inv_v)
}
