% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ageRanges.R
\name{ageRanges}
\alias{ageRanges}
\title{Find the age range for each taxon in a dataframe}
\usage{
ageRanges(Data, Taxonomy = "genus")
}
\arguments{
\item{Data}{A data frame downloaded from the paleobiology database API.}

\item{Taxonomy}{A characer string identifying the desired level of the taxonomic hierarchy.}
}
\value{
A numeric matrix of first and last ages for each taxon, with tax as rownames.
}
\description{
Find the age range (first occurrence and last occurrence) for each taxon in a PBDB dataset. Can be run for any level of the taxonomic hierarchy (e.g., family, genus).
}
\details{
Returns a data frame of that states gives the time of origination and extinction for each taxon as numeric values. Note that older versions of this function automatically dropped hanging factors and NA's, but that cleaning step should ideally be dictated by the user up-front. So that functionality has been dropped. This may introduce breaking chanes in legacy scripts, but is easily fixed by standard data cleaning steps.
}
\examples{

# Download a test dataset of Cenozoic bivalves.
# DataPBDB<-downloadPBDB(Taxa="Bivalvia",StartInterval="Cenozoic",StopInterval="Cenozoic")

# Find the first occurrence and last occurrence for all Cenozoic bivalves in DataPBDB
# AgeRanges<-ageRanges(DataPBDB,"genus")

}
\author{
Andrew A. Zaffos
}
