% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tv.traits.r
\name{tv.traits}
\alias{tv.traits}
\alias{tv.eco}
\title{Load species traits from Turboveg reference list}
\usage{
tv.traits(db, trait.db = 'ecodbase.dbf', refl, ...)
}
\arguments{
\item{db}{Path name to the Turboveg database directory}

\item{trait.db}{Name of species trait dBase file, default is 'ecodbase'}

\item{refl}{Name of the taxonomic reference list, if veg is not loaded with tv.veg}

\item{\dots}{additional arguments for tv.traits}
}
\value{
data.frame of ecological traits, see \code{metainfo(refl, eco=TRUE)}
}
\description{
Loading Turboveg ecodbase or any other specified dBase file in this directory and do basic data evaluation. Empty columns are eliminated.
}
\details{
You can use the final output line to make a summary statistic for attributes with potentially misleading '0' values.
}
\author{
Florian Jansen \email{florian.jansen@uni-rostock.de}
}
