% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.vcv.test.R
\name{prop.vcv.test}
\alias{prop.vcv.test}
\title{Proportionality test of two variance-covariance matrices}
\usage{
prop.vcv.test(n, S1, S2, method = 0, pa = 0)
}
\arguments{
\item{n}{the sample size(s), given as a number or a vector of length 2}

\item{S1}{a variance-covariance matrix}

\item{S2}{a variance-covariance matrix}

\item{method}{an integer for the method of matrix inversion (see function 'minv')}

\item{pa}{an integer for the parameter of matrix inversion (see function 'minv')}
}
\value{
The P-value for the test of proportionality between two variance-covariance matrices
}
\description{
Tests the proportionality of two variance-covariance matrices
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus.IK.coord")
coords <- which(names(Tropheus.IK.coord) == "X1"):which(names(Tropheus.IK.coord) == "Y19")
proc.coord <- as.matrix(Tropheus.IK.coord[coords])

# Data reduction
phen.pca <- prcomp(proc.coord, rank. = 5, tol = sqrt(.Machine$double.eps))
pc.scores <- phen.pca$x

# Covariance matrix of each population
S.phen.pop <- cov.group(pc.scores, groups = Tropheus.IK.coord$POP.ID)

# Maximum likelihood test of proportionality between 2 covariance matrices
# (IKA1 relative to IKS5) - 71 and 75 are the sample sizes
prop.vcv.test(n = c(71, 75), S.phen.pop[,,"IKA1"], S.phen.pop[,,"IKS5"])

}
\references{
Mardia KV, Kent JT, Bibby JM (1979)
\emph{Multivariate analysis}. Academic Press, London.
}
\seealso{
\code{\link{relative.eigen}} for the computation of relative eigenvalues,

\code{\link{minv}} for the method and the parameter used for the matrix inversion,

\code{\link[stats:Chisquare]{pchisq}} for Chi-squared distribution
}
