% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specs.R
\name{v_specs_indicator}
\alias{v_specs_indicator}
\title{Add indicator to chart}
\usage{
v_specs_indicator(vc, ...)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}}.}

\item{...}{Options for the legend, see examples or
\href{https://www.visactor.io/vchart/option/commonChart#indicator}{online documentation}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Add indicator to chart
}
\examples{

library(vchartr)

electricity_mix \%>\% 
  subset(country == "France") \%>\%
  vchart() \%>\% 
  v_pie(
    aes(x = source, y = generation),
    outerRadius = 0.8,
    innerRadius = 0.5,
    padAngle = 0.6
  ) \%>\%
  v_specs_tooltip(visible = FALSE) \%>\% 
  v_specs_indicator(
    visible = TRUE,
    trigger = "hover",
    limitRatio = 0.5,
    title = list(
      visible = TRUE,
      autoFit = TRUE,
      fitStrategy = "inscribed",
      style = list(
        fontWeight = "bolder",
        fill = "#888",
        text = JS("datum => datum !== null ? datum.x : ''")
      )
    ),
    content = list(
      list(
        visible = TRUE,
        autoFit = TRUE,
        fitStrategy = "inscribed",
        style = list(
          fontWeight = "bolder",
          fill = "#000",
          text = JS("datum => datum !== null ? Math.round(datum.y) + 'TWh' : ''")
        )
      )
    )
  )
}
