% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facets.R
\name{v_facet_wrap}
\alias{v_facet_wrap}
\title{Facets for vchart}
\usage{
v_facet_wrap(
  vc,
  facets,
  nrow = NULL,
  ncol = NULL,
  scales = c("fixed", "free", "free_y", "free_x"),
  labeller = label_value
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{facets}{Variable(s) to use for facetting, wrapped in \code{vars(...)}.}

\item{nrow, ncol}{Number of row and column in output matrix.}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"}, \code{"free_y"})?}

\item{labeller}{A function with one argument containing for each facet the value of the faceting variable.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create matrix of charts by row and column faceting variable (\code{v_facet_grid}),
or by specified number of row and column for faceting variable(s) (\code{v_facet_wrap}).
}
\examples{
library(vchartr)
library(ggplot2)

# Use vars() to supply faceting variables:
vchart(mpg) \%>\% 
  v_scatter(aes(displ, hwy)) \%>\% 
  v_facet_wrap(vars(class))

# Control the number of rows and columns with nrow and ncol
vchart(mpg) \%>\% 
  v_scatter(aes(displ, hwy)) \%>\% 
  v_facet_wrap(vars(class), ncol = 3)

# You can facet by multiple variables
vchart(mpg) \%>\% 
  v_scatter(aes(displ, hwy)) \%>\% 
  v_facet_wrap(vars(cyl, drv))

# Use the `labeller` option to control how labels are printed:
vchart(mpg) \%>\% 
  v_scatter(aes(displ, hwy)) \%>\% 
  v_facet_wrap(vars(cyl, drv), labeller = label_both)

# To change the order in which the panels appear, change the levels
# of the underlying factor.
mpg$class2 <- reorder(mpg$class, mpg$displ)
vchart(mpg) \%>\% 
  v_scatter(aes(displ, hwy)) \%>\% 
  v_facet_wrap(vars(class2), ncol = 3)

# By default, the same scales are used for all panels. You can allow
# scales to vary across the panels with the `scales` argument.
vchart(mpg) \%>\% 
  v_scatter(aes(displ, hwy)) \%>\% 
  v_facet_wrap(vars(class), scales = "free")
}
