% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcPB.R
\name{pb}
\alias{pb}
\title{Peters-Belson Disparity Analysis}
\usage{
pb(formula, group, data, family = "gaussian")
}
\arguments{
\item{formula}{a formula for the model.}

\item{group}{a vector within the \code{data} which is used for separating majority and minority groups.}

\item{data}{a data frame and data has to be included with the form of \code{data.frame}.}

\item{family}{a character indicating which model should be used. Details can be found later.}
}
\value{
\code{pb} returns an object of class \code{"pb"}, which is a list containing
following components:

\item{call}{a matched call.}
\item{overall_disparity}{overall disparity between major and minor groups.}
\item{explained_disparity}{explained disparity between major and minor groups.}
\item{unexplained_disparity}{unexplained disparity between major and minor groups.}
\item{major}{a majority group label.}
\item{minor}{a minority group label.}
}
\description{
Function \code{pb} offers Peters-Belson(PB) type of regression method which gets the disparity between a majority group
and a minority group based on various regression models.
}
