% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{GLS_chol}
\alias{GLS_chol}
\alias{GLS_chol.spam.chol.NgPeyton}
\alias{GLS_chol.matrix}
\title{GLS Estimate using Cholesky Factor}
\usage{
GLS_chol(R, X, y)

\method{GLS_chol}{spam.chol.NgPeyton}(R, X, y)

\method{GLS_chol}{matrix}(R, X, y)
}
\arguments{
\item{R}{(\code{spam.chol.NgPeyton} or \code{matrix(n, n)}) \cr Cholesky factor of
the covariance matrix \eqn{\Sigma}. If covariance tapering and sparse
matrices are used, then the input is of class \code{spam.chol.NgPeyton}.
Otherwise, \code{R} is the output of a standard \code{\link[base]{chol}},
i.e., a simple \code{matrix}}

\item{X}{(\code{matrix(n, p)}) \cr Data / design matrix.}

\item{y}{(\code{numeric(n)}) \cr Response vector}
}
\value{
A \code{numeric(p)} vector, i.e., the mean effects.
}
\description{
Computes the GLS estimate using the formula:
\deqn{\mu_{GLS} = (X^\top \Sigma^{-1} X)^{-1}X^\top \Sigma^{-1} y.}
The computation is done depending on the input class of the Cholesky factor
\code{R}. It relies on the classical \code{\link[base]{solve}} or on
using \code{forwardsolve} and \code{backsolve} functions of package
\code{spam}, see \code{\link[spam]{solve}}. This is much faster than
computing the inverse of \eqn{\Sigma}, especially since we have to compute
the Cholesky decomposition of \eqn{\Sigma} either way.
}
\examples{
# generate data
n <- 10
X <- cbind(1, 20+1:n)
y <- rnorm(n)
A <- matrix(runif(n^2)*2-1, ncol=n)
Sigma <- t(A) \%*\% A
# two possibilities
## using standard Cholesky decomposition
R_mat <- chol(Sigma); str(R_mat)
mu_mat <- GLS_chol(R_mat, X, y)
## using spam
R_spam <- chol(spam::as.spam(Sigma)); str(R_spam)
mu_spam <- GLS_chol(R_spam, X, y)
# should be identical to the following
mu <- solve(crossprod(X, solve(Sigma, X))) \%*\%
      crossprod(X, solve(Sigma, y))
## check
abs(mu - mu_mat)
abs(mu - mu_spam)
}
\author{
Jakob Dambon
}
